/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import journeymap.common.waypoint.GroupSettings;
import journeymap.common.waypoint.Settings;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.predefined.AllWaypointsGroup;
import journeymap.common.waypoint.predefined.DeathWaypointGroup;
import journeymap.common.waypoint.predefined.LockedGroup;

public class WaypointGroupCodecs {
    static MapCodec<GroupSettings> GROUP_SETTINGS_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("enable").forGetter(Settings::isEnabled), (App)Codec.BOOL.fieldOf("showDeviation").forGetter(Settings::showDeviation), (App)Codec.BOOL.fieldOf("locked").forGetter(GroupSettings::isLocked), (App)Codec.BOOL.fieldOf("colorOverride").forGetter(GroupSettings::isColorOverride), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("display").forGetter(GroupSettings::getDisplaySettings)).apply((Applicative)instance, GroupSettings::new));
    public static Codec<WaypointGroupImpl> V1_WAYPOINT_GROUP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(WaypointGroupImpl::getName), (App)Codec.STRING.optionalFieldOf("version", (Object)"1").forGetter(WaypointGroupImpl::getVersion), (App)Codec.STRING.fieldOf("modId").forGetter(WaypointGroupImpl::getModId), (App)Codec.STRING.fieldOf("guid").forGetter(WaypointGroupImpl::getGuid), (App)Codec.STRING.optionalFieldOf("description").forGetter(group -> Optional.ofNullable(group.getDescription())), (App)Codec.INT.optionalFieldOf("color").forGetter(group -> Optional.ofNullable(group.getColor())), (App)WaypointIcon.CODEC.fieldOf("icon").forGetter(WaypointGroupImpl::getIcon), (App)GROUP_SETTINGS_CODEC.fieldOf("settings").forGetter(WaypointGroupImpl::getSettings), (App)Codec.STRING.optionalFieldOf("customData").forGetter(group -> Optional.ofNullable(group.getCustomData())), (App)Codec.STRING.optionalFieldOf("tag").forGetter(group -> Optional.ofNullable(group.getTag()))).apply((Applicative)instance, (name, version, modId, guid, description, color, icon, settings, customData, tag) -> switch (guid) {
        case "journeymap_all" -> new AllWaypointsGroup((String)name, (String)version, (String)modId, (String)guid, (Optional<String>)description, (Optional<Integer>)color, (WaypointIcon)icon, (GroupSettings)settings, (Optional<String>)customData);
        case "journeymap_death" -> new DeathWaypointGroup((String)name, (String)version, (String)modId, (String)guid, (Optional<String>)description, (Optional<Integer>)color, (WaypointIcon)icon, (GroupSettings)settings, (Optional<String>)customData);
        case "journeymap_temp" -> new LockedGroup((String)name, (String)version, (String)modId, (String)guid, (Optional<String>)description, (Optional<Integer>)color, (WaypointIcon)icon, (GroupSettings)settings, (Optional<String>)customData, "Temp");
        default -> new WaypointGroupImpl((String)name, (String)version, (String)modId, (String)guid, (Optional<String>)description, (Optional<Integer>)color, (WaypointIcon)icon, (GroupSettings)settings, (Optional<String>)customData, tag.orElse(null));
    }));
}

