/*
 * Decompiled with CFR 0.152.
 */
package net.superkat.explosiveenhancement.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.loader.api.FabricLoader;
import net.superkat.explosiveenhancement.ExplosiveEnhancement;

public class ExplosiveConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    public static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("explosiveenhancement.json");
    public static File file = PATH.toFile();
    public static ExplosiveConfig INSTANCE = ExplosiveConfig.load();
    public boolean showBlastWave = true;
    public boolean showFireball = true;
    public boolean showMushroomCloud = true;
    public boolean showSparks = true;
    public float sparkSize = 5.3f;
    public float sparkOpacity = 0.7f;
    public boolean showDefaultExplosion = false;
    public boolean underwaterExplosions = true;
    public boolean showShockwave = true;
    public boolean showUnderwaterBlastWave = true;
    public int bubbleAmount = 50;
    public boolean showUnderwaterSparks = false;
    public float underwaterSparkSize = 4.0f;
    public float underwaterSparkOpacity = 0.3f;
    public boolean showDefaultExplosionUnderwater = false;
    public boolean dynamicSize = true;
    public boolean dynamicUnderwater = true;
    public boolean extraPower = false;
    public float bigExtraPower = 0.0f;
    public float smallExtraPower = 0.0f;
    public boolean attemptBetterSmallExplosions = true;
    public double smallExplosionYOffset = -0.5;
    public boolean attemptPowerKnockbackCalc = false;
    public boolean bypassPowerForSingleplayer = true;
    public boolean modEnabled = true;
    public boolean emissiveExplosion = true;
    public boolean emissiveWaterExplosion = true;
    public boolean alwaysShow = false;
    public boolean debugLogs = false;

    public static ExplosiveConfig load() {
        ExplosiveConfig config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (ExplosiveConfig)GSON.fromJson((Reader)fileReader, ExplosiveConfig.class);
            }
            catch (IOException e) {
                ExplosiveEnhancement.LOGGER.error("[Explosive Enhancement]: Could not load Explosive Config. Using default configuration.", (Throwable)e);
            }
        }
        if (config == null) {
            config = new ExplosiveConfig();
        }
        config.save();
        return config;
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(PATH, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            ExplosiveEnhancement.LOGGER.error("[Explosive Enhancement]: Could not save Explosive Config.", (Throwable)e);
        }
    }
}

