/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.misc.HolderType;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import io.netty.buffer.ByteBuf;

public record ArmorTrimPattern(String assetName, int itemId, Tag description, boolean decal) {
    public static final HolderType<ArmorTrimPattern> TYPE = new HolderType<ArmorTrimPattern>(){

        @Override
        public ArmorTrimPattern readDirect(ByteBuf buffer) {
            String assetName = (String)Types.STRING.read(buffer);
            int itemId = Types.VAR_INT.readPrimitive(buffer);
            Tag description = (Tag)Types.TAG.read(buffer);
            boolean decal = buffer.readBoolean();
            return new ArmorTrimPattern(assetName, itemId, description, decal);
        }

        @Override
        public void writeDirect(ByteBuf buffer, ArmorTrimPattern value) {
            Types.STRING.write(buffer, value.assetName());
            Types.VAR_INT.writePrimitive(buffer, value.itemId());
            Types.TAG.write(buffer, value.description());
            buffer.writeBoolean(value.decal());
        }
    };

    public ArmorTrimPattern rewrite(Int2IntFunction idRewriteFunction) {
        return new ArmorTrimPattern(this.assetName, idRewriteFunction.applyAsInt(this.itemId), this.description, this.decal);
    }
}

