/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.minecraft.item.data.MapDecoration;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectOpenHashMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;

public record MapDecorations(Map<String, MapDecoration> decorations) {
    public static final Type<MapDecorations> TYPE = new Type<MapDecorations>(MapDecorations.class){

        @Override
        public MapDecorations read(ByteBuf buffer) {
            Object2ObjectOpenHashMap<String, MapDecoration> decorations = new Object2ObjectOpenHashMap<String, MapDecoration>();
            int size = Types.VAR_INT.readPrimitive(buffer);
            for (int i = 0; i < size; ++i) {
                String id = (String)Types.STRING.read(buffer);
                MapDecoration decoration = (MapDecoration)MapDecoration.TYPE.read(buffer);
                decorations.put(id, decoration);
            }
            return new MapDecorations(decorations);
        }

        @Override
        public void write(ByteBuf buffer, MapDecorations value) {
            Types.VAR_INT.writePrimitive(buffer, value.decorations.size());
            for (Map.Entry<String, MapDecoration> entry : value.decorations.entrySet()) {
                Types.STRING.write(buffer, entry.getKey());
                MapDecoration.TYPE.write(buffer, entry.getValue());
            }
        }
    };
}

