/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.ArrayType;
import io.netty.buffer.ByteBuf;

public record AttributeModifiers1_21(AttributeModifier[] modifiers, boolean showInTooltip) {
    public static final Type<AttributeModifiers1_21> TYPE = new Type<AttributeModifiers1_21>(AttributeModifiers1_21.class){

        @Override
        public AttributeModifiers1_21 read(ByteBuf buffer) {
            AttributeModifier[] modifiers = (AttributeModifier[])AttributeModifier.ARRAY_TYPE.read(buffer);
            boolean showInTooltip = buffer.readBoolean();
            return new AttributeModifiers1_21(modifiers, showInTooltip);
        }

        @Override
        public void write(ByteBuf buffer, AttributeModifiers1_21 value) {
            AttributeModifier.ARRAY_TYPE.write(buffer, value.modifiers());
            buffer.writeBoolean(value.showInTooltip());
        }
    };

    public record AttributeModifier(int attribute, ModifierData modifier, int slotType) {
        public static final Type<AttributeModifier> TYPE = new Type<AttributeModifier>(AttributeModifier.class){

            @Override
            public AttributeModifier read(ByteBuf buffer) {
                int attribute = Types.VAR_INT.readPrimitive(buffer);
                ModifierData modifier = (ModifierData)ModifierData.TYPE.read(buffer);
                int slot = Types.VAR_INT.readPrimitive(buffer);
                return new AttributeModifier(attribute, modifier, slot);
            }

            @Override
            public void write(ByteBuf buffer, AttributeModifier value) {
                Types.VAR_INT.writePrimitive(buffer, value.attribute);
                ModifierData.TYPE.write(buffer, value.modifier);
                Types.VAR_INT.writePrimitive(buffer, value.slotType);
            }
        };
        public static final Type<AttributeModifier[]> ARRAY_TYPE = new ArrayType<AttributeModifier>(TYPE);
    }

    public record ModifierData(String id, double amount, int operation) {
        public static final Type<ModifierData> TYPE = new Type<ModifierData>(ModifierData.class){

            @Override
            public ModifierData read(ByteBuf buffer) {
                String id = (String)Types.STRING.read(buffer);
                double amount = buffer.readDouble();
                int operation = Types.VAR_INT.readPrimitive(buffer);
                return new ModifierData(id, amount, operation);
            }

            @Override
            public void write(ByteBuf buffer, ModifierData value) {
                Types.STRING.write(buffer, value.id);
                buffer.writeDouble(value.amount);
                Types.VAR_INT.writePrimitive(buffer, value.operation);
            }
        };
    }
}

