/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.ui.component.dropdown.DropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import net.minecraft.class_2960;
import net.minecraft.class_4185;
import net.minecraft.class_4706;

public class DomainDropDownButton
extends DropDownButton {
    static String currentDomain;
    private final Map<String, DropDownItem> itemMap = Maps.newHashMap();
    private final DropDownItem all = new DropDownItem((SelectableParent)this, null, Constants.getString("jm.colorpalette.domain", Constants.getString("jm.colorpalette.domain_all")), "");

    public DomainDropDownButton(ColorPalette colorPalette, class_4185.class_4241 onPress) {
        super("", onPress);
        this.setItems(this.createListItems(colorPalette));
        this.setSelected(currentDomain);
        if (this.items.size() <= 2) {
            this.setVisible(false);
        }
    }

    private List<DropDownItem> createListItems(ColorPalette colorPalette) {
        String namespace;
        class_4706 domains = class_4706.method_34958();
        for (String blockId : colorPalette.getAllBlocks()) {
            namespace = class_2960.method_60654((String)blockId).method_12836();
            if (namespace.equals("minecraft")) continue;
            domains.add((Object)namespace);
        }
        for (String biomeId : colorPalette.getAllBiomes()) {
            namespace = class_2960.method_60654((String)biomeId).method_12836();
            if (namespace.equals("minecraft")) continue;
            domains.add((Object)namespace);
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.all);
        list.add(new DropDownItem((SelectableParent)this, (Object)"minecraft", "Minecraft", ""));
        for (String domain : domains) {
            list.add(this.dropDown(domain));
        }
        return list;
    }

    private DropDownItem dropDown(String domain) {
        String name = Services.COMMON_SERVICE.getModName(domain);
        if (name.isEmpty()) {
            name = domain;
        }
        String tooltip = domain.equals(name) ? "" : domain;
        DropDownItem dropDownItem = new DropDownItem((SelectableParent)this, (Object)domain, name, tooltip);
        this.itemMap.put(domain, dropDownItem);
        return dropDownItem;
    }

    private void setSelected(String modId) {
        DropDownItem selected = modId == null ? this.all : this.itemMap.get(modId);
        currentDomain = selected != null ? modId : null;
        this.setSelected(selected);
    }

    @Override
    public void setSelected(DropDownItem selectedButton) {
        this.selected = selectedButton;
        if (this.selected == null && currentDomain == null) {
            super.setSelected(this.all);
            return;
        }
        currentDomain = this.selected != null ? (String)this.selected.getId() : null;
        super.setSelected(this.selected);
    }
}

