/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import journeymap.client.model.entity.EntityHelper;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.RenderUtil;

public class GeckoLibHelper {
    public static EntityHelper.IconData getIconData(class_1297 entity) {
        GeoModel geoModel = RenderUtil.getGeoModelForEntity((class_1297)entity);
        if (geoModel == null) {
            return null;
        }
        class_2960 modelResourceLocation = geoModel.getModelResource((GeoAnimatable)entity, null);
        String path = modelResourceLocation.method_12832();
        if (path.endsWith(".geo.json")) {
            path = path.substring(0, path.length() - 9);
        } else if (path.endsWith(".json")) {
            path = path.substring(0, path.length() - 5);
        }
        if (path.startsWith("geo/")) {
            path = path.substring(4);
        }
        path = path.replace(".", "_");
        path = path.replace("/", "_");
        EntityHelper.IconData iconData = new EntityHelper.IconData();
        iconData.type = modelResourceLocation.method_45136(path);
        return iconData;
    }

    public static List<class_630> getModelParts(class_1297 entity, class_2960 mobLocation, boolean onlyHead) {
        Optional geoBone;
        GeoModel geoModel = RenderUtil.getGeoModelForEntity((class_1297)entity);
        if (geoModel == null) {
            return null;
        }
        class_2960 modelResourceLocation = geoModel.getModelResource((GeoAnimatable)entity, null);
        BakedGeoModel model = geoModel.getBakedModel(modelResourceLocation);
        String type = mobLocation.method_12832();
        String type2 = type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase();
        if (onlyHead && (geoBone = model.getBone("head").or(() -> model.getBone("Head")).or(() -> model.getBone("heads")).or(() -> model.getBone("Heads")).or(() -> model.getBone(type)).or(() -> model.getBone(type2))).isPresent()) {
            return List.of(GeckoLibHelper.toVanillaModelPart((GeoBone)geoBone.get()));
        }
        return GeckoLibHelper.toVanillaModelParts(model.topLevelBones());
    }

    private static List<class_630> toVanillaModelParts(List<GeoBone> geoBones) {
        ArrayList<class_630> modelParts = new ArrayList<class_630>();
        for (GeoBone bone : geoBones) {
            modelParts.add(GeckoLibHelper.toVanillaModelPart(bone));
        }
        return modelParts;
    }

    private static class_630 toVanillaModelPart(GeoBone geoBone) {
        class_4587 poseStack = new class_4587();
        poseStack.method_22907(class_7833.field_40718.rotation((float)Math.PI));
        return GeckoLibHelper.toVanillaModelPart(poseStack, geoBone);
    }

    private static class_630 toVanillaModelPart(class_4587 poseStack, GeoBone geoBone) {
        poseStack.method_22903();
        BoneSnapshot initial = geoBone.getInitialSnapshot();
        poseStack.method_46416(-initial.getOffsetX() / 16.0f, initial.getOffsetY() / 16.0f, initial.getOffsetZ() / 16.0f);
        RenderUtil.translateToPivotPoint((class_4587)poseStack, (GeoBone)geoBone);
        if (initial.getRotZ() != 0.0f) {
            poseStack.method_22907(class_7833.field_40718.rotation(initial.getRotZ()));
        }
        if (initial.getRotY() != 0.0f) {
            poseStack.method_22907(class_7833.field_40716.rotation(initial.getRotY()));
        }
        if (initial.getRotX() != 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotation(initial.getRotX()));
        }
        poseStack.method_22905(initial.getScaleX(), initial.getScaleY(), initial.getScaleZ());
        RenderUtil.translateAwayFromPivotPoint((class_4587)poseStack, (GeoBone)geoBone);
        ArrayList<class_630.class_628> cubes = new ArrayList<class_630.class_628>();
        for (GeoCube geoCube : geoBone.getCubes()) {
            cubes.add(GeckoLibHelper.toVanillaCube(poseStack, geoCube));
        }
        HashMap children = Maps.newHashMap();
        for (GeoBone childGeoBone : geoBone.getChildBones()) {
            children.put(childGeoBone.getName(), GeckoLibHelper.toVanillaModelPart(poseStack, childGeoBone));
        }
        poseStack.method_22909();
        return new class_630(cubes, (Map)children);
    }

    private static class_630.class_628 toVanillaCube(class_4587 poseStack, GeoCube geoCube) {
        class_630.class_628 cube = new class_630.class_628(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 1.0f, 1.0f, EnumSet.allOf(class_2350.class));
        poseStack.method_22903();
        RenderUtil.translateToPivotPoint((class_4587)poseStack, (GeoCube)geoCube);
        RenderUtil.rotateMatrixAroundCube((class_4587)poseStack, (GeoCube)geoCube);
        RenderUtil.translateAwayFromPivotPoint((class_4587)poseStack, (GeoCube)geoCube);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        for (int quadIndex = 0; quadIndex < Math.min(geoCube.quads().length, 6); ++quadIndex) {
            Object[] vertices = new class_630.class_618[4];
            Arrays.fill(vertices, new class_630.class_618(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
            cube.field_3649[quadIndex] = new class_630.class_593((class_630.class_618[])vertices, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, false, class_2350.field_11036);
            GeoQuad geoQuad = geoCube.quads()[quadIndex];
            for (int vertexIndex = 0; vertexIndex < geoQuad.vertices().length; ++vertexIndex) {
                GeoVertex geoVertex = geoQuad.vertices()[vertexIndex];
                Vector3f geoPosition = geoVertex.position();
                Vector4f position = poseState.transform(new Vector4f(geoPosition.x(), geoPosition.y(), geoPosition.z(), 1.0f));
                position.mul(16.0f);
                cube.field_3649[quadIndex].comp_3184()[vertexIndex] = new class_630.class_618(new Vector3f(position.x(), position.y(), position.z()), geoVertex.texU(), geoVertex.texV());
            }
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)geoQuad.normal()));
            RenderUtil.fixInvertedFlatCube((GeoCube)geoCube, (Vector3f)normal);
            cube.field_3649[quadIndex].comp_3185().set((Vector3fc)normal);
        }
        poseStack.method_22909();
        return cube;
    }
}

