/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.mixin.client;

import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import javax.annotation.Nullable;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureAccess;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1043.class})
public abstract class DynamicTextureMixin
implements TextureAccess {
    @Unique
    private Integer journeymap$renderWidth;
    @Unique
    private Integer journeymap$renderHeight;
    @Unique
    private final Float2ObjectMap<class_1043> journeymap$scaledImageMap = new Float2ObjectOpenHashMap();

    @Shadow
    @Nullable
    public abstract class_1011 method_4525();

    @Inject(method={"close()V"}, at={@At(value="HEAD")})
    private void journeymap$onClose(CallbackInfo ci) {
        if (!this.journeymap$scaledImageMap.isEmpty()) {
            this.journeymap$scaledImageMap.values().forEach(tex -> {
                if (tex.method_4525() != null && this.method_4525() != null && tex.method_4525().field_4988 != this.method_4525().field_4988) {
                    tex.close();
                }
            });
        }
    }

    @Override
    public int journeymap$getWidth() {
        if (this.journeymap$renderWidth != null && this.journeymap$hasImage()) {
            return this.journeymap$renderWidth;
        }
        if (this.journeymap$hasImage()) {
            return this.method_4525().method_4307();
        }
        return 0;
    }

    @Override
    public int journeymap$getHeight() {
        if (this.journeymap$renderHeight != null && this.journeymap$hasImage()) {
            return this.journeymap$renderHeight;
        }
        if (this.journeymap$hasImage()) {
            return this.method_4525().method_4323();
        }
        return 0;
    }

    @Override
    public void journeymap$setDisplayWidth(int width) {
        this.journeymap$renderWidth = width;
    }

    @Override
    public void journeymap$setDisplayHeight(int height) {
        this.journeymap$renderHeight = height;
    }

    @Override
    public class_1043 journeymap$getScaledImage(float drawScale) {
        if (drawScale == 1.0f && !this.journeymap$hasImage()) {
            return (class_1043)this;
        }
        class_1043 scaledTexture = (class_1043)this.journeymap$scaledImageMap.get(drawScale);
        try {
            if (scaledTexture == null) {
                class_1011 img = ImageUtil.getScaledImage(drawScale, this.method_4525(), false);
                scaledTexture = new class_1043(img);
                ((TextureAccess)scaledTexture).journeymap$putScale(drawScale, scaledTexture);
                this.journeymap$scaledImageMap.put(drawScale, (Object)scaledTexture);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return scaledTexture;
    }

    @Override
    public void journeymap$putScale(float scale, class_1043 tex) {
        this.journeymap$scaledImageMap.put(scale, (Object)tex);
    }

    @Override
    public boolean journeymap$hasImage() {
        return this.method_4525() != null && this.method_4525().field_4988 > 0L;
    }
}

