/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.scoreboardoverhaul;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.scoreboardoverhaul.common.MainKt;
import me.jfenn.scoreboardoverhaul.common.config.ConfigManager;
import me.jfenn.scoreboardoverhaul.common.config.ScoreboardConfig;
import me.jfenn.scoreboardoverhaul.common.hud.HudRenderer;
import me.jfenn.scoreboardoverhaul.common.hud.HudState;
import me.jfenn.scoreboardoverhaul.impl.DrawService;
import me.jfenn.scoreboardoverhaul.impl.HudCallbackImpl;
import me.jfenn.scoreboardoverhaul.impl.KeyBindingManager;
import me.jfenn.scoreboardoverhaul.impl.OptionsAccessor;
import me.jfenn.scoreboardoverhaul.impl.ScoreboardAccessor;
import net.fabricmc.api.ClientModInitializer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u001c\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lme/jfenn/scoreboardoverhaul/Main;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "scoreboardoverhaul"})
public final class Main
implements ClientModInitializer {
    @NotNull
    public static final Main INSTANCE = new Main();
    private static final Logger log = LoggerFactory.getLogger(INSTANCE.getClass());

    private Main() {
    }

    public void onInitializeClient() {
        log.info("Starting Scoreboard Overhaul client");
        MainKt.registerResourcePacks();
        ScoreboardAccessor scoreboardAccessor = new ScoreboardAccessor();
        Logger logger = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        ConfigManager configManager = new ConfigManager(logger);
        ScoreboardConfig config = configManager.read();
        HudState hudState = new HudState(config, scoreboardAccessor, OptionsAccessor.INSTANCE, KeyBindingManager.INSTANCE);
        HudRenderer hudRenderer = new HudRenderer(config, hudState, OptionsAccessor.INSTANCE, new HudCallbackImpl(DrawService.Companion));
        hudState.init();
        hudRenderer.init();
    }
}

